<?php
/**
 * Template for Blog Layout 6
 *
 * @package     Astra
 * @link        https://wpastra.com/
 * @since       Astra 4.6.0
 */

?>
<div <?php astra_blog_layout_class( 'blog-layout-6' ); ?>>
	<div class="post-content <?php echo wp_kses_post( astra_attr( 'ast-grid-common-col' ) ); ?>" >
		<?php astra_blog_post_thumbnail_and_title_order(); ?>
		<div class="entry-content clear"
		<?php
				echo wp_kses_post(
					astra_attr(
						'article-entry-content-blog-layout',
						array(
							'class' => '',
						)
					) 
				);
				?>
		>
			<?php
				astra_entry_content_before();
				astra_entry_content_after();

				wp_link_pages(
					array(
						'before'      => '<div class="page-links">' . esc_html( astra_default_strings( 'string-blog-page-links-before', false ) ),
						'after'       => '</div>',
						'link_before' => '<span class="page-link">',
						'link_after'  => '</span>',
					)
				);
				?>
		</div><!-- .entry-content .clear -->
	</div><!-- .post-content -->
</div> <!-- .blog-layout-6 -->
